/*
 * Decompiled with CFR 0.152.
 */
package fotofiles;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FotoFiles
extends JPanel
implements ActionListener {
    private static final String newline = "\n";
    JButton openButton;
    JButton convertButton;
    JButton unifiButton;
    JTextArea log = new JTextArea(8, 100);
    JFileChooser fc;
    File fileOrigen = null;
    static Integer cuantas = 0;
    static Integer cuantasCp = 0;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManager.put("swing.boldMetal", Boolean.FALSE);
                FotoFiles.createAndShowGUI();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.openButton) {
            int returnVal = this.fc.showOpenDialog(this);
            if (returnVal == 0) {
                this.fileOrigen = this.fc.getSelectedFile();
                this.log.append("Ubicaci\u00f3n de las Fotos:... " + this.fileOrigen.getPath() + "." + newline);
            } else {
                this.log.append("Open command cancelled by user.\n");
            }
            this.log.setCaretPosition(this.log.getDocument().getLength());
        } else if (e.getSource() == this.convertButton) {
            this.log.append("\nConvirtiendo ... ... ...");
            try {
                Integer i = FotoFiles.cambiarFormatoConservandoTamanoMismaRuta(this.fileOrigen.getPath() + "/");
                this.log.append("\nSe han convertido... " + i);
            }
            catch (IOException ex) {
                Logger.getLogger(FotoFiles.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else if (e.getSource() == this.unifiButton) {
            if (this.fileOrigen == null) {
                System.out.println("No ha seleccionado un archivo");
            } else {
                try {
                    Integer i = FotoFiles.unificaContenidoFotos(this.fileOrigen.getPath(), this.fileOrigen.getPath() + "/todasUnif/");
                    this.log.append(newline + i + " Imagenes unificadas.. ");
                }
                catch (IOException ex) {
                    Logger.getLogger(FotoFiles.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    protected static ImageIcon createImageIcon(String path) {
        URL imgURL = FotoFiles.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public FotoFiles() {
        super(new BorderLayout());
        this.log.setMargin(new Insets(5, 5, 5, 5));
        this.log.setEditable(false);
        JScrollPane logScrollPane = new JScrollPane(this.log);
        this.fc = new JFileChooser();
        this.fc.setFileSelectionMode(1);
        this.fc.setAcceptAllFileFilterUsed(false);
        this.openButton = new JButton("Abrir ubicaci\u00f3n de png...");
        this.openButton.setBackground(Color.LIGHT_GRAY);
        this.openButton.addActionListener(this);
        this.convertButton = new JButton("Convertir a jpgs...", FotoFiles.createImageIcon("images/Save16.gif"));
        this.convertButton.setBackground(Color.YELLOW);
        this.convertButton.addActionListener(this);
        this.unifiButton = new JButton("Unificar Fotograf\u00edas");
        this.unifiButton.setBackground(Color.darkGray);
        this.unifiButton.setForeground(Color.white);
        this.unifiButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.openButton);
        buttonPanel.add(this.convertButton);
        buttonPanel.add(this.unifiButton);
        this.add((Component)buttonPanel, "First");
        this.add((Component)logScrollPane, "Center");
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("Convertir png a jpg, Unificar archivos en un directorio");
        frame.setDefaultCloseOperation(3);
        frame.add(new FotoFiles());
        frame.pack();
        frame.setVisible(true);
    }

    public static Integer cambiarFormatoConservandoTamanoMismaRuta(String path) throws IOException {
        String rutaOrigen = path;
        Path pathOrigen = Paths.get(rutaOrigen, new String[0]);
        File directorio = new File(rutaOrigen);
        String[] files = directorio.list();
        for (int i = 0; i < files.length; ++i) {
            File f = new File(path + "" + files[i]);
            if (f.isDirectory()) {
                FotoFiles.cambiarFormatoConservandoTamanoMismaRuta(f.getPath() + "/");
                continue;
            }
            if (!f.getName().toLowerCase().endsWith(".png")) continue;
            File input = new File(path + f.getName());
            File output = new File(path + f.getName().replace(".png", ".jpg"));
            BufferedImage image = ImageIO.read(input);
            BufferedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            result.createGraphics().drawImage(image, 0, 0, Color.WHITE, null);
            ImageIO.write((RenderedImage)result, "jpg", output);
            Integer n = cuantas;
            Integer n2 = cuantas = Integer.valueOf(cuantas + 1);
        }
        return cuantas;
    }

    public static Integer unificaContenidoFotos(String path, String dest) throws IOException {
        String linea = "";
        File dirOri = new File(path);
        File dirDest = new File(dest);
        dirDest.mkdir();
        if (dirOri.exists()) {
            File[] arraDirContent;
            for (File d : arraDirContent = dirOri.listFiles()) {
                if (d.isDirectory() && !d.toString().equals(dest)) {
                    FotoFiles.unificaContenidoFotos(d.getAbsolutePath(), dest);
                    continue;
                }
                File dirDestino = new File(dest + d.getName().toString().replace(" ", ""));
                Files.copy(Paths.get(d.getAbsolutePath(), new String[0]), Paths.get(dirDestino.getAbsolutePath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                Integer n = cuantasCp;
                Integer n2 = cuantasCp = Integer.valueOf(cuantasCp + 1);
            }
        }
        return cuantasCp;
    }
}

